const Sequelize = require('sequelize');
module.exports = function(sequelize, DataTypes) {
  var seq = sequelize.define('tbl_batchsummary_detail_temp', {
    SerNo: {
      type: DataTypes.INTEGER,
      allowNull: false
    },
    RepSerNo: {
      type: DataTypes.INTEGER,
      allowNull: true
    },
    RecSeqNo: {
      type: DataTypes.INTEGER,
      allowNull: true
    },
    Date: {
      type: DataTypes.DATEONLY,
      allowNull: true
    },
    Time: {
      type: DataTypes.TIME,
      allowNull: true
    },
    InstrumentID: {
      type: DataTypes.STRING(200),
      allowNull: true,
      defaultValue: "NULL"
    },
    Side: {
      type: DataTypes.STRING(10),
      allowNull: true,
      defaultValue: "NULL"
    },
    Min: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    Max: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    Avg: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    MinTimeDT: {
      type: DataTypes.TIME,
      allowNull: true,
      defaultValue: "00:00:00"
    },
    MaxTimeDT: {
      type: DataTypes.TIME,
      allowNull: true,
      defaultValue: "00:00:00"
    },
    AvgTimeDT: {
      type: DataTypes.TIME,
      allowNull: true,
      defaultValue: "00:00:00"
    },
    TestResult: {
      type: DataTypes.STRING(200),
      allowNull: true,
      defaultValue: "NULL"
    },
    UserID: {
      type: DataTypes.STRING(200),
      allowNull: true,
      defaultValue: "NULL"
    },
    UserName: {
      type: DataTypes.STRING(200),
      allowNull: true,
      defaultValue: "NULL"
    },
    HMIID: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL"
    },
    Deviation: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL"
    },
    NoOfSample: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL"
    },
    InitialWeight: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL"
    },
    FinalWeight: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL"
    },
    Min_Per: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    Max_Per: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    SFOID: {
      type: DataTypes.STRING(250),
      allowNull: false,
      defaultValue: "NA"
    },
    Repetition: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    LHSContainerNo: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL"
    },
    RHSContainerNo: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL"
    },
    LSL: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL"
    },
    USL: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL"
    },
    Target: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL"
    },
    EndDate: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL"
    },
    EndTime: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL"
    },
    StartTime: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL"
    },
    LODValue:{
      type:DataTypes.STRING(50),
      allowNull:true,
      defaultValue:"NULL"
    },
    TargetDT:{
      type: DataTypes.TIME,
      allowNull: true,
      defaultValue: "00:00:00"
    },
    Lot: {
        type: DataTypes.STRING(50),
        allowNull: true,
        defaultValue: "NULL"
    },
    MesTestType: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    SprayPeriod: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    DataValue: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    DataValue1: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    DataValue2: {
      type: DataTypes.STRING(50),
      allowNull: true
    }
  }, {
    sequelize,
    tableName: 'tbl_batchsummary_detail_temp',
    schema: 'dbo',
    timestamps: false,
  });
  seq.removeAttribute('id')
  return seq
};
